# Imports
import numpy as np
import matplotlib.pyplot as plt

def trace_approx(fichier, fichierP, choix):
    """Fonction pour tracer les polynomes, fichier correspond au fichier des x, f(x) et fichierP contient les poitns initiaux"""
    
    X, Xp = [], []
    Y, Yp = [], []

    if choix == 1:
        abs = "Densité (t/m**3)"
        ord = "Température (Celsius)"
        titre = "Densité de l'eau en focntion de la température."
        x_min = -0.5
        x_max = 38.5

        
    elif choix == 2:
        abs = "Revenus des employés"
        ord = "Depense des loisirs mensuels"
        titre = "Relation entre les revenus des employés et leurs dépenses de loisirs mensuels"
        x_min = 450
        x_max = 922

        
    elif choix == 3:
        abs = "x"
        ord = "y"
        titre = "Serie S dûe à Anscombe"
        x_min = 3.5
        x_max = 14.8

    elif choix == 4:
        abs = ""
        ord = ""
        titre = "Loi de Pareto"
        x_min = 19
        x_max = 505
                

    with open(fichier, encoding="utf-8") as f: #methode vu en Python pour les maths
        for ligne in f:
            donnees = ligne.split(" ")

            if choix != 4:
                X = [x_min, x_max]
                Y.append(x_min*float(donnees[0])+ float(donnees[1]))
                Y.append(x_max*float(donnees[0])+ float(donnees[1]))
            else :
                X = [i for i in range(x_min, x_max+1)]
                Y = [float(donnees[1])*x**(float(donnees[0])) for x in X]
            

    plt.plot(X, Y, color="red")
    plt.xlabel(abs)
    plt.ylabel(ord)
    plt.title(titre)
    

    with open(fichierP, encoding="utf-8") as f:
        for ligne in f:
            donnees = ligne.split(" ")
            Xp.append(float(donnees[0]))
            Yp.append(float(donnees[1]))

    plt.plot(Xp, Yp, 'b+', label="Points de départ")

    
    plt.legend()
    plt.show()

if __name__ == "__main__":
    
    trace_approx("polynome1_A.txt", "polynome1.txt", 1)

    #2.
    trace_approx("polynome2_A.txt", "polynome2.txt", 2)

    #3.
    trace_approx("polynome3_A.txt", "polynome3.txt", 3)

    #4.
    trace_approx("polynome4_A.txt", "polynome4.txt", 4)
